<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudDataplex;

class GoogleCloudDataplexV1AssetStatus extends \Google\Model
{
  /**
   * Number of active assets.
   *
   * @var int
   */
  public $activeAssets;
  /**
   * Number of assets that are in process of updating the security policy on
   * attached resources.
   *
   * @var int
   */
  public $securityPolicyApplyingAssets;
  /**
   * Last update time of the status.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Number of active assets.
   *
   * @param int $activeAssets
   */
  public function setActiveAssets($activeAssets)
  {
    $this->activeAssets = $activeAssets;
  }
  /**
   * @return int
   */
  public function getActiveAssets()
  {
    return $this->activeAssets;
  }
  /**
   * Number of assets that are in process of updating the security policy on
   * attached resources.
   *
   * @param int $securityPolicyApplyingAssets
   */
  public function setSecurityPolicyApplyingAssets($securityPolicyApplyingAssets)
  {
    $this->securityPolicyApplyingAssets = $securityPolicyApplyingAssets;
  }
  /**
   * @return int
   */
  public function getSecurityPolicyApplyingAssets()
  {
    return $this->securityPolicyApplyingAssets;
  }
  /**
   * Last update time of the status.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDataplexV1AssetStatus::class, 'Google_Service_CloudDataplex_GoogleCloudDataplexV1AssetStatus');
