ALTER TABLE `expenses` DROP `payment_account_id`;
ALTER TABLE `payrolls` DROP `payment_account_id`;
ALTER TABLE `supplier_payments` DROP `payment_account_id`;
ALTER TABLE `transactions` DROP `payment_account_id`;
ALTER TABLE `transactions` DROP `is_pos_transaction`;


CREATE TABLE `cash_registers` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` int UNSIGNED NOT NULL DEFAULT '0',
  `parent_id` int UNSIGNED NOT NULL DEFAULT '0',
  `starting_time` timestamp NULL DEFAULT NULL,
  `closing_time` timestamp NULL DEFAULT NULL,
  `starting_amount` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `closing_amount` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `starting_note` text COLLATE utf8mb4_unicode_ci,
  `closing_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


CREATE TABLE `cash_register_transactions` (
  `id` bigint UNSIGNED NOT NULL,
  `cash_register_id` int UNSIGNED NOT NULL DEFAULT '0',
  `amount` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `trx_type` tinyint DEFAULT NULL COMMENT '1=ale, 9=Expense',
  `details` text COLLATE utf8mb4_unicode_ci,
  `payment_type_id` int UNSIGNED NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


ALTER TABLE `cash_registers` ADD PRIMARY KEY (`id`);
ALTER TABLE `cash_register_transactions` ADD PRIMARY KEY (`id`);
ALTER TABLE `cash_registers` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `cash_register_transactions` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `sale_payments` DROP `payment_account_id`;

INSERT INTO `staff_permissions` (`id`, `name`, `guard_name`, `group_name`, `created_at`, `updated_at`) VALUES
(147, 'view  cash register report', 'web', 'other', NULL, NULL),
(146, 'view  cash register', 'web', 'other', NULL, NULL);
