import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/warehouse/warehouse_data_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class WarehouseRepo {
  Future<ResponseModel> getWarehouseData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.warehouseDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateWarehouseRepo(
      WarehouseDataModel model, String warehouseId) async {
    final map = modelToMap(model);

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.updateWarehouseEndPoint}/$warehouseId';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Map<String, dynamic> modelToMap(WarehouseDataModel model) {
    Map<String, dynamic> bodyFields = {
      'name': model.warehouseName,
      'address': model.address,
      'contact_number': model.contact,
      'city': model.city,
      'state': model.state,
      'postcode': model.postCode,
    };

    return bodyFields;
  }

  Future<dynamic> warehouseStatusChangeData(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.warehouseStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
