import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class VariantRepo {
  Future<ResponseModel> getVariantData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.variantDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateVariant(
      String variantName, variantId, attributeId) async {
    final map = {
      'name': variantName,
      'attribute': attributeId,
    };

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.variantUpdateEndPoint}$variantId';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<dynamic> variantStatusChangeData(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.variantStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
