import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class UnitRepo {
  Future<ResponseModel> getUnitData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.unitDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateUnit(String attributeName, id, shortName) async {
    final map = {'name': attributeName, 'short_name': shortName};

    String url = '${UrlContainer.baseUrl}${UrlContainer.unitUpdateEndPoint}$id';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<dynamic> unitStatusChangeRepo(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.unitStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
