import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewUnitRepo {
  Future<ResponseModel> createUnitRepo(
      String unitName, String unitShortName) async {
    final map = {
      'name': unitName.toString(),
      'short_name': unitShortName.toString()
    };

    String url = '${UrlContainer.baseUrl}${UrlContainer.createUnitEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }
}
