import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class TaxRepo {
  Future<ResponseModel> getTaxData(String param) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.taxDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateTax(String variantName, percentage, taxId) async {
    final map = {
      'name': variantName,
      'percentage': percentage,
    };

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.taxUpdateEndPoint}$taxId';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<dynamic> taxStatusChangeData(
    String id,
  ) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.taxStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
