import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewTaxRepo {
  Future<ResponseModel> createTax(String taxName, percentage) async {
    final map = {
      'name': taxName,
      'percentage': percentage,
    };

    String url = '${UrlContainer.baseUrl}${UrlContainer.createTaxEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }
}
