import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/supplier/supplier_data.dart';
import 'package:ovosale/data/services/api_service.dart';

class SupplierRepo {
  Future<ResponseModel> getSupplierData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.supplierDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateSupplier(
      SupplierDataModel model, supplierId) async {
    final map = {
      'name': model.name,
      'email': model.email,
      'mobile': model.mobile,
      'address': model.address,
      'city': model.city,
      'state': model.state,
      'zip': model.zip,
      'postcode': model.postcode,
      'company_name': model.companyName,
    };
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.supplierUpdateEndPoint}$supplierId';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<dynamic> supplierStatusChangeData(
    String id,
  ) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.supplierStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
