import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/supplier/supplier_data.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewSupplierRepo {
  Future<ResponseModel> createNewSupplierRepo(SupplierDataModel model) async {
    final map = modelToMap(model);
    String url = '${UrlContainer.baseUrl}${UrlContainer.newSupplierEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Map<String, dynamic> modelToMap(SupplierDataModel model) {
    Map<String, dynamic> bodyFields = {
      'name': model.name,
      'email': model.email,
      'mobile': model.mobile,
      'address': model.address,
      'city': model.city,
      'state': model.state,
      'zip': model.zip,
      'postcode': model.postcode,
      'company_name': model.companyName,
    };

    return bodyFields;
  }
}
