import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class RoleandPermissionRepo {
  Future<dynamic> getRoleAndPermissionData() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.roleDataEndPoint}';
    ResponseModel response = await ApiService.getRequest(url);
    return response;
  }

  Future<dynamic> roleStatusChangeData(
    String id,
  ) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.roleStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }

  Future<dynamic> updatePaymentMethodData(String id, String name) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.roleUpdateEndPoint}$id';

    final map = {
      'name': name.toString(),
    };
    ResponseModel response = await ApiService.postRequest(url, map);
    return response;
  }
}
