import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewRoleandPermissionRepo {
  Future<dynamic> getRoleAndPermissionData(String roleId) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.newRoleDataEndPoint}$roleId';
    ResponseModel response = await ApiService.getRequest(url);
    return response;
  }

  Future<dynamic> roleStatusChangeData(String id, String name) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.roleStatusChangeEndPoint}$id';

    final map = {
      'name': name.toString(),
    };
    ResponseModel response = await ApiService.postRequest(url, map);
    return response;
  }

  Future<dynamic> updateRoleandPermissionRepo(
      String id, Map<String, dynamic> map) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.rolePermissionUpdateEndPoint}$id';
    ResponseModel response =
        await ApiService.postMultiPartRequest(url, map, {});
    return response;
  }
}
