import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../services/api_service.dart';

class ReportRepo {
  Future<ResponseModel> getStockReport({required String pram}) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.stockReportEndPoint}$pram';

    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> getSalesReport({required String pram}) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.salesReportEndPoint}$pram';

    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> getPurchaseReport({required String pram}) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.purchaseReportEndPoint}$pram';

    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> getExpenseReport({required String pram}) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.expenseReportEndPoint}$pram';

    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> getProfitLossReport({required String pram}) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.profitLossReportEndPoint}$pram';

    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> getRequiredData() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.requiredDataEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }
}
