import 'dart:io';

import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class EditPurchaseRepo {
  Future<dynamic> getPurchaseData(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.editPurchaseDataEndPoint}$id';
    ResponseModel response = await ApiService.getRequest(url);
    return response;
  }

  Future<dynamic> getProductsData(String productName) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.producSearchDataEndPoint}$productName';
    ResponseModel response = await ApiService.getRequest(url);
    return response;
  }

  Future<ResponseModel> createPurchase(
      Map<String, dynamic> map, File? attachment, String id) async {
    Map<String, File> attachmentFiles = {};
    if (attachment != null) {
      attachmentFiles['attachment'] = attachment;
    }

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.updatePurchaseEndPoint}$id';
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, attachmentFiles);

    return responseModel;
  }
}
