import 'dart:io';

import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class EditProfileRepo {
  Future<ResponseModel> editProfileRepo(
      String name, String email, File? profileImage) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.editProfileEndPoint}';
    Map<String, dynamic> map = {
      "name": name.toString(),
      "email": email.toString()
    };
    Map<String, File> attachmentFiles = {};
    if (profileImage != null) {
      attachmentFiles['image'] = profileImage;
    }
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, attachmentFiles);

    return responseModel;
  }
}
