import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class ProductMethodRepo {
  Future<dynamic> getPaymentMethodData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.paymentMethodsDataEndPoint}$param';
    ResponseModel response = await ApiService.getRequest(url);
    return response;
  }

  Future<dynamic> paymentMethodStatusChangeData(
    String id,
  ) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.paymentMethodStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }

  Future<dynamic> updatePaymentMethodData(String id, String name) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.paymentMethodUpdateEndPoint}$id';

    final map = {
      'name': name.toString(),
    };
    ResponseModel response = await ApiService.postRequest(url, map);
    return response;
  }
}
