import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../services/api_service.dart';

class PaymentRepo {
  Future<ResponseModel> getPaymentMethod() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.paymentMethodEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> getViewSaleData(String saleId) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.saleView}/$saleId';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> confirmSale({required map}) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.confirmSaleEndPoint}';
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, {});

    return responseModel;
  }

  Future<ResponseModel> downloadPdf({required String saleId}) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.downloadPdfEndPoint}/$saleId';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }
}
