import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewVariantRepo {
  Future<ResponseModel> createVariant(String variantName, attributeId) async {
    final map = {
      'name': variantName,
      'attribute': attributeId,
    };

    String url = '${UrlContainer.baseUrl}${UrlContainer.createVariantEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<ResponseModel> getAttributeData() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.attributeDataEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }
}
