import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../services/api_service.dart';

class NewSaleRepo {
  Future<ResponseModel> getRequiredData() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.requiredDataEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> getNewSalesData({required String searchPram}) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.newSaleEndPoint}$searchPram';
    print("this is url><<<<<<<<<<<<<<<<$url");
    // String url = '${UrlContainer.baseUrl}${UrlContainer.newSaleEndPoint}?warehouse_id=$selectedWarehouseId';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> addToCart(Map<String, String> pram) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.addToCartEndPoint}';

    ResponseModel responseModel = await ApiService.postRequest(url, pram);

    return responseModel;
  }

  Future<ResponseModel> getCartCount() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.cartCountEndPoint}';

    ResponseModel responseModel = await ApiService.postRequest(url, {});

    return responseModel;
  }
}
