import 'dart:io';

import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewProductRepo {
  Future<ResponseModel> getProductDataRepo() async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.getDatatoCreateProductEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );
    return responseModel;
  }

  Future<ResponseModel> getUpdateProductDataRepo(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.getDatatoUpdateProductEndPoint}$id';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> createProduct(
      Map<String, dynamic> map, File? attachment) async {
    Map<String, File> attachmentFiles = {};
    if (attachment != null) {
      attachmentFiles['image'] = attachment;
    }

    String url = '${UrlContainer.baseUrl}${UrlContainer.createProductEndPoint}';
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, attachmentFiles);

    return responseModel;
  }

  Future<ResponseModel> updateProduct(
      Map<String, dynamic> map, File? attachment, String productId) async {
    Map<String, File> attachmentFiles = {};
    if (attachment != null) {
      attachmentFiles['image'] = attachment;
    }

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.updateProductEndPoint}$productId';
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, attachmentFiles);

    return responseModel;
  }
}
