import 'dart:io';

import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewCategoryRepo {
  Future<ResponseModel> createCategory(
      String categoryName, File? attachment) async {
    final map = {
      'name': categoryName.toString(),
    };
    Map<String, File> attachmentFiles = {};
    if (attachment != null) {
      attachmentFiles['image'] = attachment;
    }

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.createPCategoryEndPoint}';
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, attachmentFiles);

    return responseModel;
  }
}
