import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class MoreRepo {
  Future<ResponseModel> logout() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.logoutUrl}';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    await clearSharedPrefData();

    return responseModel;
  }

  Future<void> clearSharedPrefData() async {
    await SharedPreferenceService.setString(SharedPreferenceService.userNameKey, '');
    await SharedPreferenceService.setString(SharedPreferenceService.userEmailKey, '');
    await SharedPreferenceService.setString(SharedPreferenceService.accessTokenType, '');
    await SharedPreferenceService.deleteAccessToken();
    await SharedPreferenceService.setBool(SharedPreferenceService.rememberMeKey, false);
    return Future.value();
  }
}
