import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class HomeRepo {
  Future<ResponseModel> getDashboardData() async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.dashBoardUrl}";
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );
    return responseModel;
  }

  Future<ResponseModel> getSalesData({required String filterType}) async {
    String url =
        "${UrlContainer.baseUrl}${UrlContainer.salesUrl}?filter_type=$filterType";
    ResponseModel responseModel = await ApiService.getRequest(url);
    return responseModel;
  }

  Future<ResponseModel> getRecentTransaction({required String trxType}) async {
    String url =
        "${UrlContainer.baseUrl}${UrlContainer.recentTransactionUrl}?trx_type=$trxType";
    ResponseModel responseModel = await ApiService.getRequest(url);
    return responseModel;
  }
}
