import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class ExpenseCategoryRepo {
  Future<ResponseModel> updateExpenseRepo(String name, String expenseId) async {
    final map = {
      'name': name,
    };

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.updateExpenseCategoryEndPoint}$expenseId';

    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<ResponseModel> getExpenseCategoryRepo(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.expenseDataCategoryEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> getExtendedExpenseCategoryRepo(
      String pageNumber) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.expenseDataCategoryEndPoint}?page=$pageNumber';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<dynamic> expenseCategoryStatusChangeData(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.expenseCategoryStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }

  Future<ResponseModel> createNewExpenseCategoryRepo(String name) async {
    final map = {
      'name': name,
    };

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.createExpenseCategoryEndPoint}';

    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }
}
