import 'dart:io';

import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/expense/expense_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewExpenseRepo {
  Future<ResponseModel> getPaymentMethod() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.paymentMethodEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> createNewExpenseRepo(ExpenseDataModel model) async {
    final map = {
      'expense_date': model.expenseDate,
      'reference_no': model.referenceNumber,
      'comment': model.comment,
      'expense_purpose': model.expensePurpose,
      'amount': model.amount,
      'payment_type': model.methodTypeId,
      'payment_account': model.methodAccountId.toString(),
    };

    Map<String, File> attachmentFiles = {};
    if (model.attachment != null) {
      attachmentFiles['attachment'] = model.attachment!;
    }

    String url = '${UrlContainer.baseUrl}${UrlContainer.createExpenseEndPoint}';

    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, attachmentFiles);

    return responseModel;
  }

  Future<ResponseModel> getExpenseCategoryRepo() async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.expenseDataCategoryEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }
}
