import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/customer/customer_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class NewCustomerRepo {
  Future<ResponseModel> createCustomerRepo(CustomerDataModel model) async {
    final map = modelToMap(model);

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.createCustomerEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Map<String, dynamic> modelToMap(CustomerDataModel model) {
    Map<String, dynamic> bodyFields = {
      'name': model.name,
      'email': model.email,
      'mobile': model.contact,
      'address': model.address,
      'city': model.city,
      'state': model.state,
      'country': model.country,
      'zip': model.zip,
      'postcode': model.postcode,
    };

    return bodyFields;
  }
}
