import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/customer/customer_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class CustomerRepo {
  Future<ResponseModel> getCustomerData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.customerDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> getExtendedCustomerDataRepo(String pageNumber) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.customerDataEndPoint}?page=$pageNumber';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateCustomerRepo(
      CustomerDataModel model, String id) async {
    final map = {
      'name': model.name,
      'email': model.email,
      'mobile': model.contact,
      'address': model.address,
      'city': model.city,
      'state': model.state,
      'country': model.country,
      'zip': model.zip,
      'postcode': model.postcode,
    };

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.updateCustomerEndPoint}$id';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<dynamic> customerStatusChangeData(
    String id,
  ) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.customerStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postRequest(url, {});
    return response;
  }
}
