import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/coupon/coupon_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class CouponRepo {
  Future<ResponseModel> getSaleCouponData() async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.saleCouponDataEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> getCouponData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.couponDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> applyCoupon(
      {required String coupon, required String subtotal}) async {
    Map<String, String> map = {
      "coupon_code": coupon,
      "subtotal": subtotal,
    };

    String url = '${UrlContainer.baseUrl}${UrlContainer.applyCouponEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<ResponseModel> updateCoupon(CouponDataModel model, couponId) async {
    final map = {
      'coupon_name': model.couponName,
      'coupon_code': model.couponCode,
      'minimum_amount': model.minimumAmount,
      'discount_type': model.discountType,
      'amount': model.amount,
      'start_from': model.startFrom,
      'end_at': model.endAt,
      'maximum_using_time': model.maxUseTime,
      'description': model.description,
    };
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.couponUpdateEndPoint}$couponId';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<dynamic> couponStatusChangeData(
    String id,
  ) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.couponStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
