import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/coupon/coupon_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class AddNewCouponRepo {
  Future<ResponseModel> createNewCouponRepo(CouponDataModel model) async {
    final map = modelToMap(model);

    String url = '${UrlContainer.baseUrl}${UrlContainer.createCouponEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Map<String, dynamic> modelToMap(CouponDataModel model) {
    Map<String, dynamic> bodyFields = {
      'coupon_name': model.couponName,
      'coupon_code': model.couponCode,
      'minimum_amount': model.minimumAmount,
      'discount_type': model.discountType,
      'amount': model.amount,
      'start_from': model.startFrom,
      'end_at': model.endAt,
      'maximum_using_time': model.maxUseTime,
      'description': model.description,
    };

    return bodyFields;
  }
}
