import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../services/api_service.dart';

class CheckoutRepo {
  Future<ResponseModel> getCheckoutData() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.checkoutEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> updateQuantity(
      {required String quantity, required String cardId}) async {
    Map<String, String> pram = {
      'quantity': quantity,
    };

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.updateQuantityEndPoint}/$cardId';
    ResponseModel responseModel = await ApiService.postRequest(url, pram);

    return responseModel;
  }

  Future<ResponseModel> clearCart() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.clearCartEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(url);

    return responseModel;
  }

  Future<ResponseModel> removeCart({required String cartId}) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.clearCartEndPoint}/$cartId';
    ResponseModel responseModel = await ApiService.getRequest(url);
    return responseModel;
  }
}
