import 'dart:io';

import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class CategoryRepo {
  Future<ResponseModel> getCategoryData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.categoryDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> searchCategories(
    String query,
  ) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.categoryDataEndPoint}?search=$query';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateCategory(
      String categoryName, String categoryId, File? attachment) async {
    final map = {
      'name': categoryName.toString(),
    };
    Map<String, File> attachmentFiles = {};
    if (attachment != null) {
      attachmentFiles['image'] = attachment;
    }

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.updateCategoryEndPoint}$categoryId';
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, attachmentFiles);

    return responseModel;
  }

  Future<dynamic> categoryStatusChangeData(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.categoryStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
