import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../services/api_service.dart';

class GlobalRepo {
  Future<ResponseModel> addToCart(Map<String, String> pram) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.addToCartEndPoint}';

    ResponseModel responseModel = await ApiService.postRequest(url, pram);

    return responseModel;
  }

  Future<ResponseModel> getCartCount() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.cartCountEndPoint}';

    ResponseModel responseModel = await ApiService.postRequest(url, {});

    return responseModel;
  }

  Future<ResponseModel> getWareHouseData({required String pram}) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.wareHouseEndPoint}$pram';
    ResponseModel responseModel = await ApiService.getRequest(url);
    return responseModel;
  }

  Future<ResponseModel> getAssignPermission() async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.assignPermissionEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, {});

    return responseModel;
  }
}
