import 'dart:io';

import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class BrandRepo {
  Future<ResponseModel> getBrandData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.brandDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateBrandRepo(
      String brandName, String brandId, File? attachment) async {
    final map = {
      'name': brandName.toString(),
    };
    Map<String, File> attachmentFiles = {};
    if (attachment != null) {
      attachmentFiles['image'] = attachment;
    }

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.updateBrandEndPoint}$brandId';
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, map, attachmentFiles);

    return responseModel;
  }

  Future<dynamic> brandStatusChangeData(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.brandStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
