import 'package:get/get.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/auth/verification/email_verification_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';

class LoginRepo {
  Future<ResponseModel> loginUser(String email, String password) async {
    Map<String, String> map = {'username': email, 'password': password};
    String url = '${UrlContainer.baseUrl}${UrlContainer.loginEndPoint}';
    final response = await ApiService.postRequest(url, map);
    return response;
  }

  Future<String> forgetPassword(String type, String value) async {
    final map = modelToMap(value, type);
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.forgetPasswordEndPoint}';
    final response = await ApiService.postRequest(url, map);

    EmailVerificationModel model =
        EmailVerificationModel.fromJson(response.responseJson);

    if (model.status.toLowerCase() == "success") {
      SharedPreferenceService.setUserEmail(model.data?.email ?? '');
      CustomSnackBar.success(successList: [
        '${MyStrings.passwordResetEmailSentTo.tr} ${model.data?.email ?? MyStrings.yourEmail.tr}'
      ]);
      return model.data?.email ?? '';
    } else {
      CustomSnackBar.error(
          errorList: model.message ?? [MyStrings.requestFail.tr]);
      return '';
    }
  }

  Map<String, String> modelToMap(String value, String type) {
    Map<String, String> map = {'type': type, 'value': value};
    return map;
  }

  Future<EmailVerificationModel> verifyForgetPassCode(String code) async {
    String? email = SharedPreferenceService.getString(
        SharedPreferenceService.userEmailKey,
        defaultValue: '');
    Map<String, String> map = {'code': code, 'email': email};

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.passwordVerifyEndPoint}';

    final response = await ApiService.postRequest(url, map);

    EmailVerificationModel model =
        EmailVerificationModel.fromJson(response.responseJson);
    if (model.status == 'success') {
      model.setCode(200);
      return model;
    } else {
      model.setCode(400);
      return model;
    }
  }

  Future<ResponseModel> resetPassword(
      String email, String password, String code) async {
    Map<String, String> map = {
      'token': code,
      'email': email,
      'password': password,
      'password_confirmation': password,
    };

    String url = '${UrlContainer.baseUrl}${UrlContainer.resetPasswordEndPoint}';

    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<bool> sendUpdatedToken(String deviceToken) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.deviceTokenEndPoint}';
    Map<String, String> map = deviceTokenMap(deviceToken);
    await ApiService.postRequest(url, map);
    return true;
  }

  Map<String, String> deviceTokenMap(String deviceToken) {
    Map<String, String> map = {'token': deviceToken.toString()};
    return map;
  }
}
