import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class GeneralSettingRepo {
  Future<dynamic> getGeneralSetting() async {
    String url = UrlContainer.generalSettingEndPoint;
    ResponseModel response = await ApiService.getRequest(url);
    return response;
  }

  Future<dynamic> getLanguage(String languageCode) async {
    try {
      String url = '${UrlContainer.languageUrl}$languageCode';
      ResponseModel response = await ApiService.getRequest(url);
      return response;
    } catch (e) {
      return ResponseModel(
          isSuccess: false,
          message: MyStrings.somethingWentWrong,
          statusCode: 300,
          responseJson: "");
    }
  }
}
