import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

class AttributeRepo {
  Future<ResponseModel> getAttributeData(String param) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.attributeDataEndPoint}$param';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> getExtendedAttributeData(String pageNumber) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.attributeDataEndPoint}?page=$pageNumber';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );

    return responseModel;
  }

  Future<ResponseModel> updateAttribute(String attributeName, id) async {
    final map = {
      'name': attributeName,
    };

    String url =
        '${UrlContainer.baseUrl}${UrlContainer.attributeUpdateEndPoint}$id';
    ResponseModel responseModel = await ApiService.postRequest(url, map);

    return responseModel;
  }

  Future<dynamic> attributeStatusChangeData(String id) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.attributeStatusChangeEndPoint}$id';

    ResponseModel response = await ApiService.postMultiPartRequest(url, {}, {});
    return response;
  }
}
