import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';

import '../../model/profile/profile_post_model.dart';

class SettingsRepo {
  Future<ResponseModel> updateProfile(ProfilePostModel model) async {
    String url = UrlContainer.updateProfileEndPoint;

    Map<String, String> finalMap = {
      'firstname': model.firstname,
      'lastname': model.lastName,
      'address': model.address ?? '',
      'zip': model.zip ?? '',
      'state': model.state ?? "",
      'city': model.city ?? '',
    };

    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, finalMap, {});
    return responseModel;
  }

  Future<ResponseModel> updateCompanySettings(Map<String, String> prams) async {
    String url =
        '${UrlContainer.baseUrl}${UrlContainer.companySettingEndPoint}';
    ResponseModel responseModel =
        await ApiService.postMultiPartRequest(url, prams, {});
    return responseModel;
  }

  Future<ResponseModel> updatePrefixSettings(Map<String, String> prams) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.prefixSettingEndPoint}';
    ResponseModel responseModel = await ApiService.postRequest(url, prams);
    return responseModel;
  }

  Future<ResponseModel> loadProfileInfo() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.getProfileEndPoint}';
    ResponseModel responseModel = await ApiService.getRequest(
      url,
    );
    return responseModel;
  }

  Future<dynamic> getGeneralSetting() async {
    String url = UrlContainer.generalSettingEndPoint;
    ResponseModel response = await ApiService.getRequest(url);
    return response;
  }
}
