// To parse this JSON data, do
//
//     final warehouseResponseModel = warehouseResponseModelFromJson(jsonString);

import 'dart:convert';

WarehouseResponseModel warehouseResponseModelFromJson(String str) =>
    WarehouseResponseModel.fromJson(json.decode(str));

String warehouseResponseModelToJson(WarehouseResponseModel data) =>
    json.encode(data.toJson());

class WarehouseResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  WarehouseResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory WarehouseResponseModel.fromJson(Map<String, dynamic> json) =>
      WarehouseResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Warehouses? warehouses;

  Data({
    this.warehouses,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        warehouses: json["warehouses"] == null
            ? null
            : Warehouses.fromJson(json["warehouses"]),
      );

  Map<String, dynamic> toJson() => {
        "warehouses": warehouses?.toJson(),
      };
}

class Warehouses {
  String? currentPage;
  List<WarehouseData>? data;
  String? firstPageUrl;
  String? from;
  String? lastPage;
  String? lastPageUrl;
  List<Link>? links;
  String? nextPageUrl;
  String? path;
  String? perPage;
  String? prevPageUrl;
  String? to;
  String? total;

  Warehouses({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Warehouses.fromJson(Map<String, dynamic> json) => Warehouses(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<WarehouseData>.from(
                json["data"]!.map((x) => WarehouseData.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class WarehouseData {
  String? id;
  String? name;
  String? address;
  String? city;
  String? state;
  String? postcode;
  String? contactNumber;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  WarehouseData({
    this.id,
    this.name,
    this.address,
    this.city,
    this.state,
    this.postcode,
    this.contactNumber,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory WarehouseData.fromJson(Map<String, dynamic> json) => WarehouseData(
        id: json["id"].toString(),
        name: json["name"].toString(),
        address: json["address"].toString(),
        city: json["city"]?.toString() ?? "",
        state: json["state"]?.toString() ?? "",
        postcode: json["postcode"]?.toString() ?? "",
        contactNumber: json["contact_number"]?.toString() ?? "",
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "address": address,
        "city": city,
        "state": state,
        "postcode": postcode,
        "contact_number": contactNumber,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Link {
  String? url;
  String? label;
  bool? active;

  Link({
    this.url,
    this.label,
    this.active,
  });

  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );

  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}
