// To parse this JSON data, do
//
//     final warehosueListResponseModel = warehosueListResponseModelFromJson(jsonString);

import '../new_sale/required_data_response_model.dart';

class WareHouseListResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  WareHouseListResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory WareHouseListResponseModel.fromJson(Map<String, dynamic> json) =>
      WareHouseListResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  Warehouses? warehouses;

  Data({
    this.warehouses,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        warehouses: json["warehouses"] == null
            ? null
            : Warehouses.fromJson(json["warehouses"]),
      );
}

class Warehouses {
  List<Warehouse>? data;
  dynamic nextPageUrl;

  Warehouses({
    this.data,
    this.nextPageUrl,
  });

  factory Warehouses.fromJson(Map<String, dynamic> json) => Warehouses(
        data: json["data"] == null
            ? []
            : List<Warehouse>.from(
                json["data"]!.map((x) => Warehouse.fromJson(x))),
        nextPageUrl: json["next_page_url"],
      );
}
