// To parse this JSON data, do
//
//     final updateWarehouseResponseModel = updateWarehouseResponseModelFromJson(jsonString);

import 'dart:convert';

UpdateWarehouseResponseModel updateWarehouseResponseModelFromJson(String str) =>
    UpdateWarehouseResponseModel.fromJson(json.decode(str));

String updateWarehouseResponseModelToJson(UpdateWarehouseResponseModel data) =>
    json.encode(data.toJson());

class UpdateWarehouseResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  UpdateWarehouseResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory UpdateWarehouseResponseModel.fromJson(Map<String, dynamic> json) =>
      UpdateWarehouseResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Warehouse? warehouse;

  Data({
    this.warehouse,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        warehouse: json["warehouse"] == null
            ? null
            : Warehouse.fromJson(json["warehouse"]),
      );

  Map<String, dynamic> toJson() => {
        "warehouse": warehouse?.toJson(),
      };
}

class Warehouse {
  String? id;
  String? name;
  String? address;
  String? city;
  String? state;
  String? postcode;
  String? contactNumber;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  Warehouse({
    this.id,
    this.name,
    this.address,
    this.city,
    this.state,
    this.postcode,
    this.contactNumber,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Warehouse.fromJson(Map<String, dynamic> json) => Warehouse(
        id: json["id"].toString(),
        name: json["name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        postcode: json["postcode"].toString(),
        contactNumber: json["contact_number"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "address": address,
        "city": city,
        "state": state,
        "postcode": postcode,
        "contact_number": contactNumber,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
