// To parse this JSON data, do
//
//     final addWarehouseResponseModel = addWarehouseResponseModelFromJson(jsonString);

import 'dart:convert';

AddWarehouseResponseModel addWarehouseResponseModelFromJson(String str) =>
    AddWarehouseResponseModel.fromJson(json.decode(str));

String addWarehouseResponseModelToJson(AddWarehouseResponseModel data) =>
    json.encode(data.toJson());

class AddWarehouseResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  AddWarehouseResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory AddWarehouseResponseModel.fromJson(Map<String, dynamic> json) =>
      AddWarehouseResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Warehouse? warehouse;

  Data({
    this.warehouse,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        warehouse: json["warehouse"] == null
            ? null
            : Warehouse.fromJson(json["warehouse"]),
      );

  Map<String, dynamic> toJson() => {
        "warehouse": warehouse?.toJson(),
      };
}

class Warehouse {
  String? contactNumber;
  String? name;
  String? address;
  String? city;
  String? state;
  String? postcode;
  String? updatedAt;
  String? createdAt;
  String? id;

  Warehouse({
    this.contactNumber,
    this.name,
    this.address,
    this.city,
    this.state,
    this.postcode,
    this.updatedAt,
    this.createdAt,
    this.id,
  });

  factory Warehouse.fromJson(Map<String, dynamic> json) => Warehouse(
        contactNumber: json["contact_number"].toString(),
        name: json["name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        postcode: json["postcode"].toString(),
        updatedAt: json["updated_at"].toString(),
        createdAt: json["created_at"].toString(),
        id: json["id"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "contact_number": contactNumber,
        "name": name,
        "address": address,
        "city": city,
        "state": state,
        "postcode": postcode,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
      };
}
