// To parse this JSON data, do
//
//     final variantUpdateResponseModel = variantUpdateResponseModelFromJson(jsonString);

import 'dart:convert';

VariantUpdateResponseModel variantUpdateResponseModelFromJson(String str) =>
    VariantUpdateResponseModel.fromJson(json.decode(str));

String variantUpdateResponseModelToJson(VariantUpdateResponseModel data) =>
    json.encode(data.toJson());

class VariantUpdateResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  VariantUpdateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory VariantUpdateResponseModel.fromJson(Map<String, dynamic> json) =>
      VariantUpdateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Attribute? attribute;

  Data({
    this.attribute,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        attribute: json["attribute"] == null
            ? null
            : Attribute.fromJson(json["attribute"]),
      );

  Map<String, dynamic> toJson() => {
        "attribute": attribute?.toJson(),
      };
}

class Attribute {
  String? id;
  String? name;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  Attribute({
    this.id,
    this.name,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Attribute.fromJson(Map<String, dynamic> json) => Attribute(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
