// To parse this JSON data, do
//
//     final variantStatusChangeResponseModel = variantStatusChangeResponseModelFromJson(jsonString);

import 'dart:convert';

VariantStatusChangeResponseModel variantStatusChangeResponseModelFromJson(
        String str) =>
    VariantStatusChangeResponseModel.fromJson(json.decode(str));

String variantStatusChangeResponseModelToJson(
        VariantStatusChangeResponseModel data) =>
    json.encode(data.toJson());

class VariantStatusChangeResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  VariantStatusChangeResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory VariantStatusChangeResponseModel.fromJson(
          Map<String, dynamic> json) =>
      VariantStatusChangeResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Variant? variant;

  Data({
    this.variant,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        variant:
            json["variant"] == null ? null : Variant.fromJson(json["variant"]),
      );

  Map<String, dynamic> toJson() => {
        "variant": variant?.toJson(),
      };
}

class Variant {
  String? id;
  String? name;
  String? attributeId;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  Variant({
    this.id,
    this.name,
    this.attributeId,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Variant.fromJson(Map<String, dynamic> json) => Variant(
        id: json["id"].toString(),
        name: json["name"].toString(),
        attributeId: json["attribute_id"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "attribute_id": attributeId,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
