// To parse this JSON data, do
//
//     final variantResponseModel = variantResponseModelFromJson(jsonString);

import 'dart:convert';

VariantResponseModel variantResponseModelFromJson(String str) =>
    VariantResponseModel.fromJson(json.decode(str));

String variantResponseModelToJson(VariantResponseModel data) =>
    json.encode(data.toJson());

class VariantResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  VariantResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory VariantResponseModel.fromJson(Map<String, dynamic> json) =>
      VariantResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Variants? variants;
  List<Attribute>? attributes;

  Data({
    this.variants,
    this.attributes,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        variants: json["variants"] == null
            ? null
            : Variants.fromJson(json["variants"]),
        attributes: json["attributes"] == null
            ? []
            : List<Attribute>.from(
                json["attributes"]!.map((x) => Attribute.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "variants": variants?.toJson(),
        "attributes": attributes == null
            ? []
            : List<dynamic>.from(attributes!.map((x) => x.toJson())),
      };
}

class Attribute {
  String? id;
  String? name;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;
  String? attributeId;
  Attribute? attribute;

  Attribute({
    this.id,
    this.name,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.attributeId,
    this.attribute,
  });

  factory Attribute.fromJson(Map<String, dynamic> json) => Attribute(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        attributeId: json["attribute_id"].toString(),
        attribute: json["attribute"] == null
            ? null
            : Attribute.fromJson(json["attribute"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "attribute_id": attributeId,
        "attribute": attribute?.toJson(),
      };
}

class AttributeData {
  String? id;
  String? name;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  AttributeData({
    this.id,
    this.name,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory AttributeData.fromJson(Map<String, dynamic> json) => AttributeData(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Variants {
  String? currentPage;
  List<Attribute>? data;
  String? firstPageUrl;
  String? from;
  String? lastPage;
  String? lastPageUrl;
  List<Link>? links;
  String? nextPageUrl;
  String? path;
  String? perPage;
  String? prevPageUrl;
  String? to;
  String? total;

  Variants({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Variants.fromJson(Map<String, dynamic> json) => Variants(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<Attribute>.from(
                json["data"]!.map((x) => Attribute.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class Link {
  String? url;
  String? label;
  bool? active;

  Link({
    this.url,
    this.label,
    this.active,
  });

  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );

  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}
