// To parse this JSON data, do
//
//     final createVariantResponseModel = createVariantResponseModelFromJson(jsonString);

import 'dart:convert';

CreateVariantResponseModel createVariantResponseModelFromJson(String str) =>
    CreateVariantResponseModel.fromJson(json.decode(str));

String createVariantResponseModelToJson(CreateVariantResponseModel data) =>
    json.encode(data.toJson());

class CreateVariantResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  CreateVariantResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CreateVariantResponseModel.fromJson(Map<String, dynamic> json) =>
      CreateVariantResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Variant? variant;

  Data({
    this.variant,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        variant:
            json["variant"] == null ? null : Variant.fromJson(json["variant"]),
      );

  Map<String, dynamic> toJson() => {
        "variant": variant?.toJson(),
      };
}

class Variant {
  String? name;
  String? attributeId;
  String? updatedAt;
  String? createdAt;
  String? id;

  Variant({
    this.name,
    this.attributeId,
    this.updatedAt,
    this.createdAt,
    this.id,
  });

  factory Variant.fromJson(Map<String, dynamic> json) => Variant(
        name: json["name"].toString(),
        attributeId: json["attribute_id"].toString(),
        updatedAt: json["updated_at"].toString(),
        createdAt: json["created_at"].toString(),
        id: json["id"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "attribute_id": attributeId,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
      };
}
