// To parse this JSON data, do
//
//     final unitUpdateResponseModel = unitUpdateResponseModelFromJson(jsonString);

import 'dart:convert';

UnitUpdateResponseModel unitUpdateResponseModelFromJson(String str) =>
    UnitUpdateResponseModel.fromJson(json.decode(str));

String unitUpdateResponseModelToJson(UnitUpdateResponseModel data) =>
    json.encode(data.toJson());

class UnitUpdateResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  UnitUpdateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory UnitUpdateResponseModel.fromJson(Map<String, dynamic> json) =>
      UnitUpdateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Unit? unit;

  Data({
    this.unit,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        unit: json["unit"] == null ? null : Unit.fromJson(json["unit"]),
      );

  Map<String, dynamic> toJson() => {
        "unit": unit?.toJson(),
      };
}

class Unit {
  final String? id;
  final String? name;
  final String? shortName;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Unit({
    this.id,
    this.name,
    this.shortName,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Unit.fromJson(Map<String, dynamic> json) => Unit(
        id: json["id"].toString(),
        name: json["name"].toString(),
        shortName: json["short_name"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "short_name": shortName,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
