// To parse this JSON data, do
//
//     final unitStatusChangeResponseModel = unitStatusChangeResponseModelFromJson(jsonString);

import 'dart:convert';

UnitStatusChangeResponseModel unitStatusChangeResponseModelFromJson(
        String str) =>
    UnitStatusChangeResponseModel.fromJson(json.decode(str));

String unitStatusChangeResponseModelToJson(
        UnitStatusChangeResponseModel data) =>
    json.encode(data.toJson());

class UnitStatusChangeResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  UnitStatusChangeResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory UnitStatusChangeResponseModel.fromJson(Map<String, dynamic> json) =>
      UnitStatusChangeResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Brand? brand;

  Data({
    this.brand,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        brand: json["brand"] == null ? null : Brand.fromJson(json["brand"]),
      );

  Map<String, dynamic> toJson() => {
        "brand": brand?.toJson(),
      };
}

class Brand {
  final String? id;
  final String? name;
  final String? status;
  final String? image;
  final String? createdAt;
  final String? updatedAt;
  final String? deletedAt;
  final String? imageSrc;

  Brand({
    this.id,
    this.name,
    this.status,
    this.image,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
    this.imageSrc,
  });

  factory Brand.fromJson(Map<String, dynamic> json) => Brand(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        image: json["image"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        deletedAt: json["deleted_at"].toString(),
        imageSrc: json["image_src"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "image": image,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "deleted_at": deletedAt,
        "image_src": imageSrc,
      };
}
