// To parse this JSON data, do
//
//     final unitCreateResponseModel = unitCreateResponseModelFromJson(jsonString);

import 'dart:convert';

UnitCreateResponseModel unitCreateResponseModelFromJson(String str) =>
    UnitCreateResponseModel.fromJson(json.decode(str));

String unitCreateResponseModelToJson(UnitCreateResponseModel data) =>
    json.encode(data.toJson());

class UnitCreateResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  UnitCreateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory UnitCreateResponseModel.fromJson(Map<String, dynamic> json) =>
      UnitCreateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Unit? unit;

  Data({
    this.unit,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        unit: json["unit"] == null ? null : Unit.fromJson(json["unit"]),
      );

  Map<String, dynamic> toJson() => {
        "unit": unit?.toJson(),
      };
}

class Unit {
  final String? name;
  final String? shortName;
  final String? updatedAt;
  final String? createdAt;
  final String? id;

  Unit({
    this.name,
    this.shortName,
    this.updatedAt,
    this.createdAt,
    this.id,
  });

  factory Unit.fromJson(Map<String, dynamic> json) => Unit(
        name: json["name"].toString(),
        shortName: json["short_name"].toString(),
        updatedAt: json["updated_at"].toString(),
        createdAt: json["created_at"].toString(),
        id: json["id"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "short_name": shortName,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
      };
}
