// To parse this JSON data, do
//
//     final taxStatusChangeResponseModel = taxStatusChangeResponseModelFromJson(jsonString);

import 'dart:convert';

TaxStatusChangeResponseModel taxStatusChangeResponseModelFromJson(String str) =>
    TaxStatusChangeResponseModel.fromJson(json.decode(str));

String taxStatusChangeResponseModelToJson(TaxStatusChangeResponseModel data) =>
    json.encode(data.toJson());

class TaxStatusChangeResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  TaxStatusChangeResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory TaxStatusChangeResponseModel.fromJson(Map<String, dynamic> json) =>
      TaxStatusChangeResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Tax? tax;

  Data({
    this.tax,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        tax: json["tax"] == null ? null : Tax.fromJson(json["tax"]),
      );

  Map<String, dynamic> toJson() => {
        "tax": tax?.toJson(),
      };
}

class Tax {
  String? id;
  String? name;
  String? percentage;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  Tax({
    this.id,
    this.name,
    this.percentage,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Tax.fromJson(Map<String, dynamic> json) => Tax(
        id: json["id"].toString(),
        name: json["name"].toString(),
        percentage: json["percentage"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "percentage": percentage,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
