// To parse this JSON data, do
//
//     final taxDataResponseModel = taxDataResponseModelFromJson(jsonString);

import 'dart:convert';

TaxDataResponseModel taxDataResponseModelFromJson(String str) =>
    TaxDataResponseModel.fromJson(json.decode(str));

String taxDataResponseModelToJson(TaxDataResponseModel data) =>
    json.encode(data.toJson());

class TaxDataResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  TaxDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory TaxDataResponseModel.fromJson(Map<String, dynamic> json) =>
      TaxDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Taxes? taxes;

  Data({
    this.taxes,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        taxes: json["taxes"] == null ? null : Taxes.fromJson(json["taxes"]),
      );

  Map<String, dynamic> toJson() => {
        "taxes": taxes?.toJson(),
      };
}

class Taxes {
  String? currentPage;
  List<TaxData>? data;
  String? firstPageUrl;
  String? from;
  String? lastPage;
  String? lastPageUrl;
  List<Link>? links;
  String? nextPageUrl;
  String? path;
  String? perPage;
  String? prevPageUrl;
  String? to;
  String? total;

  Taxes({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Taxes.fromJson(Map<String, dynamic> json) => Taxes(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<TaxData>.from(json["data"]!.map((x) => TaxData.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class TaxData {
  String? id;
  String? name;
  String? percentage;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  TaxData({
    this.id,
    this.name,
    this.percentage,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory TaxData.fromJson(Map<String, dynamic> json) => TaxData(
        id: json["id"].toString(),
        name: json["name"].toString(),
        percentage: json["percentage"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "percentage": percentage,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Link {
  String? url;
  String? label;
  bool? active;

  Link({
    this.url,
    this.label,
    this.active,
  });

  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );

  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}
